<?php
function montar_xml_gnre_automatico($xml_nfe_path, $receita = '100102', $produto = '1') {
    if (!file_exists($xml_nfe_path)) {
        throw new Exception("Arquivo XML da NF-e não encontrado: $xml_nfe_path");
    }

    $xml_str = file_get_contents($xml_nfe_path);
    $xml = new DOMDocument();
    $xml->loadXML($xml_str);

    $xpath = new DOMXPath($xml);
    $xpath->registerNamespace('nfe', 'http://www.portalfiscal.inf.br/nfe');

    // ====== DADOS NF-E ======
    $identificadorGuia = $xpath->evaluate('string(//nfe:ide/nfe:nNF)');
    $numeroNFe = $identificadorGuia;
    $chave = $xpath->evaluate('string(//nfe:infNFe/@Id)');
    $chave_limpa = preg_replace('/^NFe/', '', $chave);

    // Emitente
    $cnpj_emit = $xpath->evaluate('string(//nfe:emit/nfe:CNPJ)');
    $razao_emit = $xpath->evaluate('string(//nfe:emit/nfe:xNome)');
    $ie_emit = $xpath->evaluate('string(//nfe:emit/nfe:IE)');
    $logradouro_emit = $xpath->evaluate('string(//nfe:emit/nfe:enderEmit/nfe:xLgr)');
    $numero_emit = $xpath->evaluate('string(//nfe:emit/nfe:enderEmit/nfe:nro)');
    $bairro_emit = $xpath->evaluate('string(//nfe:emit/nfe:enderEmit/nfe:xBairro)');
    $cep_emit = $xpath->evaluate('string(//nfe:emit/nfe:enderEmit/nfe:CEP)');
    $municipio_emit_ibge = $xpath->evaluate('string(//nfe:emit/nfe:enderEmit/nfe:cMun)');
    $municipio_emit = strlen($municipio_emit_ibge) === 7 ? substr($municipio_emit_ibge, -5) : $municipio_emit_ibge;
    $uf_emit = $xpath->evaluate('string(//nfe:emit/nfe:enderEmit/nfe:UF)');
//    $telefone_emit = $xpath->evaluate('string(//nfe:emit/nfe:enderEmit/nfe:fone)');

    // Destinatário
    $cnpj_dest = $xpath->evaluate('string(//nfe:dest/nfe:CNPJ)');
    $cpf_dest = $xpath->evaluate('string(//nfe:dest/nfe:CPF)');
    $ie_dest = $xpath->evaluate('string(//nfe:dest/nfe:IE)');
    $nome_dest = $xpath->evaluate('string(//nfe:dest/nfe:xNome)');
    $municipio_dest_ibge = $xpath->evaluate('string(//nfe:dest/nfe:enderDest/nfe:cMun)');
    $municipio_dest = strlen($municipio_dest_ibge) === 7 ? substr($municipio_dest_ibge, -5) : $municipio_dest_ibge;
    $uf_dest = $xpath->evaluate('string(//nfe:dest/nfe:enderDest/nfe:UF)');

    // Valores
    $valor_icms_dest = $xpath->evaluate('string(//nfe:ICMSTot/nfe:vICMSUFDest)');
    $valor_total = $valor_icms_dest ?: $xpath->evaluate('string(//nfe:ICMSTot/nfe:vNF)');
    $data_venc = date('Y-m-d', strtotime('+2 days'));

    // ====== CRIA XML GNRE ======
    $xml_gnre = new DOMDocument('1.0', 'UTF-8');
    $xml_gnre->formatOutput = true;

    $lote = $xml_gnre->createElement('TLote_GNRE');
    $lote->setAttribute('xmlns', 'http://www.gnre.pe.gov.br');
    $lote->setAttribute('versao', '2.00');
    $xml_gnre->appendChild($lote);

    $guias = $xml_gnre->createElement('guias');
    $lote->appendChild($guias);

    $guia = $xml_gnre->createElement('TDadosGNRE');
    $guia->setAttribute('versao', '2.00');
    $guias->appendChild($guia);

    // --- Cabeçalho ---
    $guia->appendChild($xml_gnre->createElement('ufFavorecida', $uf_dest));
    $guia->appendChild($xml_gnre->createElement('tipoGnre', '0'));

    // --- Contribuinte Emitente ---
    $emit = $xml_gnre->createElement('contribuinteEmitente');
    $ident = $xml_gnre->createElement('identificacao');
    
    // === Identificação do Emitente ===
if ($cnpj_emit) {
    $ident->appendChild($xml_gnre->createElement('CNPJ', $cnpj_emit));
}

// Verifica se a IE é válida para a UF favorecida
$uf_emit = strtoupper(trim($uf_emit));
$uf_dest = strtoupper(trim($uf_dest));

$enviarIE = true;
$motivoIE = '';

if (!$ie_emit || strtoupper(trim($ie_emit)) === 'ISENTO') {
    $enviarIE = false;
    $motivoIE = 'IE isenta ou não informada.';
} elseif ($uf_emit !== $uf_dest) {
    // IE do emitente não cadastrada na UF favorecida (erro 700)
    $enviarIE = false;
    $motivoIE = "UF do emitente ($uf_emit) difere da UF favorecida ($uf_dest).";
}

if ($enviarIE) {
    $ident->appendChild($xml_gnre->createElement('IE', $ie_emit));
} else {
    // Registra em log para rastrear
    $logDir = __DIR__ . '/../logs/';
    if (!is_dir($logDir)) mkdir($logDir, 0777, true);
    $logFile = $logDir . 'gnre_warn_' . date('Ymd_His') . '.log';
    $msg = "[" . date('Y-m-d H:i:s') . "] IE não enviada. Motivo: $motivoIE IE original: '$ie_emit'\n";
    file_put_contents($logFile, $msg, FILE_APPEND);
}


    $emit->appendChild($ident);
    $emit->appendChild($xml_gnre->createElement('razaoSocial', $razao_emit));
    $emit->appendChild($xml_gnre->createElement('endereco', "$logradouro_emit, $numero_emit - $bairro_emit"));
    $emit->appendChild($xml_gnre->createElement('municipio', $municipio_emit));
    $emit->appendChild($xml_gnre->createElement('uf', $uf_emit));
    $emit->appendChild($xml_gnre->createElement('cep', $cep_emit));
    $emit->appendChild($xml_gnre->createElement('telefone', $telefone_emit));
    $guia->appendChild($emit);

    // --- Itens GNRE ---
    $itens = $xml_gnre->createElement('itensGNRE');
    $item = $xml_gnre->createElement('item');
    $item->appendChild($xml_gnre->createElement('receita', $receita));
    $item->appendChild($xml_gnre->createElement('detalhamentoReceita', $receita));

    $docOrigem = $xml_gnre->createElement('documentoOrigem', $numeroNFe);
    $docOrigem->setAttribute('tipo', '10');
    $item->appendChild($docOrigem);

    $item->appendChild($xml_gnre->createElement('produto', $produto));

    $referencia = $xml_gnre->createElement('referencia');
    $referencia->appendChild($xml_gnre->createElement('periodo', '0'));
    $referencia->appendChild($xml_gnre->createElement('mes', date('m')));
    $referencia->appendChild($xml_gnre->createElement('ano', date('Y')));
    $referencia->appendChild($xml_gnre->createElement('parcela', '1'));
    $item->appendChild($referencia);

    $item->appendChild($xml_gnre->createElement('dataVencimento', $data_venc));

    $valor = $xml_gnre->createElement('valor', number_format((float)$valor_total, 2, '.', ''));
    $valor->setAttribute('tipo', '11');
    $item->appendChild($valor);

    $item->appendChild($xml_gnre->createElement('convenio', 'SEM CONVENIO'));

    // --- Destinatário ---
    $dest = $xml_gnre->createElement('contribuinteDestinatario');
    $idDest = $xml_gnre->createElement('identificacao');
    if ($cnpj_dest) $idDest->appendChild($xml_gnre->createElement('CNPJ', $cnpj_dest));
    elseif ($cpf_dest) $idDest->appendChild($xml_gnre->createElement('CPF', $cpf_dest));
    if ($ie_dest) $idDest->appendChild($xml_gnre->createElement('IE', $ie_dest));
    $dest->appendChild($idDest);
    $dest->appendChild($xml_gnre->createElement('razaoSocial', $nome_dest));
    $dest->appendChild($xml_gnre->createElement('municipio', $municipio_dest));
    $item->appendChild($dest);

    // --- Campos Extras ---
    $camposExtras = $xml_gnre->createElement('camposExtras');

    $extra1 = $xml_gnre->createElement('campoExtra');
    $extra1->appendChild($xml_gnre->createElement('codigo', '107'));
    $extra1->appendChild($xml_gnre->createElement('valor', $chave_limpa));
    $camposExtras->appendChild($extra1);

    $extra2 = $xml_gnre->createElement('campoExtra');
    $extra2->appendChild($xml_gnre->createElement('codigo', '100'));
    $extra2->appendChild($xml_gnre->createElement('valor', $razao_emit));
    $camposExtras->appendChild($extra2);

    $extra3 = $xml_gnre->createElement('campoExtra');
    $extra3->appendChild($xml_gnre->createElement('codigo', '103'));
    $extra3->appendChild($xml_gnre->createElement('valor', $cnpj_emit));
    $camposExtras->appendChild($extra3);

    $item->appendChild($camposExtras);
    $itens->appendChild($item);
    $guia->appendChild($itens);

    // --- Rodapé ---
    $guia->appendChild($xml_gnre->createElement('valorGNRE', number_format((float)$valor_total, 2, '.', '')));
    $guia->appendChild($xml_gnre->createElement('dataPagamento', $data_venc));
    $guia->appendChild($xml_gnre->createElement('identificadorGuia', $identificadorGuia));

    return $xml_gnre->saveXML();
}
?>
